<?php

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\Auth\LoginController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::get('/welcome', function () {
//     return view('welcome');
// });

Auth::routes();
Route::get('/logout', [LoginController::class, 'logout']);

Route::get('/home', [AdminController::class, 'dashboard'])->name('home');

Route::get('/', function () {
    return view('index');
});

Route::get('ContactUs', function () {
    return view('contactus');
});

Route::get('blog-page',[AdminController::class, 'getAllBlogs']);

Route::get('blog-page-detail/{id}',[AdminController::class, 'blogPageDetail']);


Route::get('Careers', function () {
    return view('career');
});

Route::get('Company', function () {
    return view('about');
});

Route::get('Project', function () {
    return view('projects');
});

Route::get('Project-Detail', function () {
    return view('projects_detail');
});

Route::get('Services', function () {
    return view('service');
});

Route::get('Services-Detail', function () {
    return view('service_detail');
});

Route::get('Service-Industries', function () {
    return view('system_price');
});
Route::get('Security-Monitoring', function () {
    return view('monitoring');
});

Route::get('Security-Difference', function () {
    return view('difference');
});

Route::get('privacy-policy', function () {
    return view('privacy-policy');
});

//---------------------Services Page-----------------//
Route::get('services/hospitality-security', [AdminController::class, 'hospitalitySecurityPage']);
Route::get('services/security-guard-staffing', [AdminController::class, 'securityGuardStaffingPage']);
Route::get('services/event-security', [AdminController::class, 'eventSecurityPage']);
Route::get('services/executive-protection', [AdminController::class, 'executiveProtectionPage']);
Route::get('services/workplace-protection-and-rif-security', [AdminController::class, 'workPlageProtectionAndRifSecurityPage']);
Route::get('services/warehouse-protection', [AdminController::class, 'wareHouseProtectionPage']);
Route::get('services/strike-security', [AdminController::class, 'strikeSecurity']);

//---------------------Email-----------------//
Route::post('email', 'mailController@postContactUs');
Route::post('contactmail', 'ContactUsController@postContactUs');


//---------------------PageDetail---------------------//
Route::get('editCategoryPageDetail/{id}',[AdminController::class,'editCategoryPageDetail']);
Route::get('categoryPageDetail/{id}',[AdminController::class,'categoryPageDetail']);
Route::get('deleteCategoryPage/{id}',[AdminController::class,'deleteCategoryPage']);
Route::get('allPages',[AdminController::class,'allPages'])->name('allPages');
Route::get('pageIndex',[AdminController::class,'pageIndex'])->name('pageIndex');

Route::get('getpageDetail', [AdminController::class, 'getpageDetail']);
Route::post('ckeditor/pagestore', [AdminController::class, 'pageStore'])->name('ckeditor.page-store');
Route::get('getAllPages', [AdminController::class, 'getAllPages']);
Route::post('update/categoyrpage', [AdminController::class, 'updateCategoryPageDetail'])->name('update.categoy-page');

//-----------------------Dashboard-------------//
Route::get('dashboard',[AdminController::class, 'DashBoard']);

//-------------------Blogs--------------//
Route::get('blogDetail/{id}',[AdminController::class,'blogDetail']);
Route::get('blogs',[AdminController::class,'blogs'])->name('blogs');
Route::get('editBlogs/{id}',[AdminController::class,'editBlogs']);
Route::get('blogIndex',[AdminController::class,'blogIndex']);
Route::get('deleteBlog/{id}',[AdminController::class,'deleteBlog']);


//-----------------------------ckeditor-----------------------------//
Route::post('ckeditor/blogstore', [AdminController::class, 'blogStore'])->name('ckeditor.blog-store');
Route::post('ckeditor/upload', [AdminController::class, 'upload'])->name('ckeditor.image-upload');
Route::post('ckeditor/blogupdate', [AdminController::class, 'blogUpdate'])->name('ckeditor.blog-update');
Route::post('ckeditor/upload', [AdminController::class, 'upload'])->name('ckeditor.image-upload');
