@extends('master')
@section('title','Services in the UAE')
@section('keywords','security services, security guards, event security in UAE')
@section('description','Our experienced team of professionals are dedicated to providing you with the highest level of service and support, ensuring that you can feel confident and protected at all times.')
@section('og:url','https://www.alsafwan.ae/Services/')
@section('og:type','services')
@section('og:image','https://www.alsafwan.ae/public/website/img/demos/construction/logo-construction.png')
@section('head')

    <style>
        @media only screen and (min-width:320px) and (max-width:414px)
        {

            html section.section-tertiary{
                background-color: white;!important;
            }
            .position{
                margin-top: -5px !important;
                margin-bottom: -35px;
                text-align: left !important;
            }

        }
    </style>

@endsection


@section('content')
<div class="body">

    <div role="main" class="main">
        <section class="section section-tertiary section-no-border pb-md mt-none">
            <div class="container">
                <div class="row mt-xl">
                    <div class="col-md-10 col-md-offset-2 pt-xlg mt-xlg align-right">
                        <h1 class="text-uppercase font-weight-light mt-xl text-color-primary position">Services</h1>
                    </div>
                </div>
            </div>
        </section>

        <div class="container">

            <div class="row pt-sm">
                <div class="col-md-3">
                    <aside class="sidebar" id="sidebar" data-plugin-sticky data-plugin-options="{'minWidth': 991, 'containerSelector': '.container', 'padding': {'top': 110}}">

                        {{--<ul class="nav nav-list mb-xl show-bg-active">--}}
                            {{--<li class="active"><a href="Services">Overview</a></li>--}}
                            {{--<li><a href="">Site Security</a></li>--}}
                            {{--<li><a href="">Security Guard Staffing</a></li>--}}
                            {{--<li><a href="">Event Security</a></li>--}}
                            {{--<li><a href="">Executive Protection</a></li>--}}
                            {{--<li><a href="">Workplace Protection & RIF Security</a></li>--}}
                            {{--<li><a href="">Warehouse Protection</a></li>--}}
                            {{--<li><a href="">Strike Security</a></li>--}}
                        {{--</ul>--}}

                        <h4 class="pt-xl mb-md text-color-dark">Contact Us</h4>
                        <p>Contact us or give us a call to discover how we can help.</p>

                        <form id="contactForm" action="contactmail" method="POST" class="mb-lg">
                            <input type="hidden" id="csrf-token" name="_token" value="{{ csrf_token() }}">
                            <div class="row">
                                <div class="form-group">
                                    <div class="col-md-12">
                                        <label>Your name *</label>
                                        <input type="text" value="" maxlength="100" class="form-control" name="name" id="name" required>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group">
                                    <div class="col-md-12">
                                        <label>Your email address *</label>
                                        <input type="email" value="" data-msg-email="Please enter a valid email address." maxlength="100" class="form-control" name="email" id="email" required>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group">
                                    <div class="col-md-12">
                                        <label>Subject *</label>
                                        <input type="text" value="" maxlength="100" class="form-control" name="subject" id="subject" required>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group">
                                    <div class="col-md-12">
                                        <label>Message *</label>
                                        <textarea maxlength="5000" rows="3" class="form-control" name="message" id="message" required></textarea>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <input type="submit" value="Send Message" class="btn btn-primary mb-xl" data-loading-text="Loading...">
                                </div>
                            </div>
                        </form>
                    </aside>

                </div>
                <div class="col-md-9">

                    <div class="row mt-lg">
                        <div class="col-md-12">
                            <div class="feature-box feature-box-style-2 mb-xl ml-xlg appear-animation" data-appear-animation="fadeInUp" data-appear-animation-delay="0">
                                <div class="feature-box-icon">
                                    <img src="{{asset('website/img/demos/construction/icons/hospitality security.png')}}" alt="hospitality security" class="img-responsive" />
                                </div>
                                <div class="feature-box-info ml-xlg">
                                    <h4 class="mb-sm">Hospitality Security</h4>
                                    <p>SGS specializes in Hospitality Security understanding the customer service that is needed at let the hotel guests feel at home & knowing the seriousness of the guests & staff security at present. We do know what is required when it comes to Hospitality Security and SGS provides dedicated whilst experience staff for this field differently.</p>
                                   <a class="mt-md" href="{{url('services/hospitality-security')}}">Learn More <i class="fa fa-long-arrow-right"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row mt-lg">
                        <div class="col-md-12">
                            <div class="feature-box feature-box-style-2 mb-xl ml-xlg appear-animation" data-appear-animation="fadeInUp" data-appear-animation-delay="0">
                                <div class="feature-box-icon">
                                    <img src="{{asset('website/img/demos/construction/icons/security guard.png')}}" alt="security guard" class="img-responsive" />
                                </div>
                                <div class="feature-box-info ml-xlg">
                                    <h4 class="mb-sm">Security Guard Staffing</h4>
                                    <p>Our modern, fully equipped, well trained and highly professional guards are our asset. They are always ready to protect you no matter what risk they put on their own lives. Their only mission is to save you.</p>
                                    <a class="mt-md" href="{{url('services/security-guard-staffing')}}">Learn More <i class="fa fa-long-arrow-right"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row mt-lg">
                        <div class="col-md-12">
                            <div class="feature-box feature-box-style-2 mb-xl ml-xlg appear-animation" data-appear-animation="fadeInUp" data-appear-animation-delay="300">
                                <div class="feature-box-icon">
                                    <img src="{{asset('website/img/demos/construction/icons/event.png')}}" alt="event" class="img-responsive" />
                                </div>
                                <div class="feature-box-info ml-xlg">
                                    <h4 class="mb-sm">Event Security</h4>
                                    <p>SGS offers a great deal of events security where you can enjoy your meetings, training sessions, product launching ceremonies and any business or corporate events in a tension free environment.</p>
                                    <a class="mt-md" href="{{url('services/event-security')}}">Learn More <i class="fa fa-long-arrow-right"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row mt-lg">
                        <div class="col-md-12">
                            <div class="feature-box feature-box-style-2 mb-xl ml-xlg appear-animation" data-appear-animation="fadeInUp" data-appear-animation-delay="300">
                                <div class="feature-box-icon">
                                    <img src="{{asset('website/img/demos/construction/icons/executive protection.png')}}" alt="executive protection" class="img-responsive" />
                                </div>
                                <div class="feature-box-info ml-xlg">
                                    <h4 class="mb-sm">Executive Protection</h4>
                                    <p>Securing celebrity or VIP officials is a hallmark of SGS. We provide security literate and professional staff to provide a flawless and infallible protection to executives.</p>
                                   <a class="mt-md" href="{{url('services/executive-protection')}}">Learn More <i class="fa fa-long-arrow-right"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row mt-lg">
                        <div class="col-md-12">
                            <div class="feature-box feature-box-style-2 mb-xl ml-xlg appear-animation" data-appear-animation="fadeInUp" data-appear-animation-delay="300">
                                <div class="feature-box-icon">
                                    <img src="{{asset('website/img/demos/construction/icons/workplaceprotection.png')}}" alt="workplaceprotection" class="img-responsive" />
                                </div>
                                <div class="feature-box-info ml-xlg">
                                    <h4 class="mb-sm">Workplace Protection & RIF Security</h4>
                                    <p>Our state of the art, modern and latest technological devices give you a retinal accuracy that allows reduction in force by 50 %. There is no need for extra resources when our security equipment in place.</p>
                                   <a class="mt-md" href="{{url('services/workplace-protection-and-rif-security')}}">Learn More <i class="fa fa-long-arrow-right"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row mt-lg">
                        <div class="col-md-12">
                            <div class="feature-box feature-box-style-2 mb-xl ml-xlg appear-animation" data-appear-animation="fadeInUp" data-appear-animation-delay="300">
                                <div class="feature-box-icon">
                                    <img src="{{asset('website/img/demos/construction/icons/warehouse.png')}}" alt="warehouse" class="img-responsive" />
                                </div>
                                <div class="feature-box-info ml-xlg">
                                    <h4 class="mb-sm">Warehouse Protection</h4>
                                    <p>Our reliable and trustworthy ware house protection service is available to secure and protect your backyard repository or depot that is actually the backbone of your trading or business store.</p>
                                    <a class="mt-md" href="{{url('services/warehouse-protection')}}">Learn More <i class="fa fa-long-arrow-right"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row mt-lg">
                        <div class="col-md-12">
                            <div class="feature-box feature-box-style-2 mb-xl ml-xlg appear-animation" data-appear-animation="fadeInUp" data-appear-animation-delay="300">
                                <div class="feature-box-icon">
                                    <img src="{{asset('website/img/demos/construction/icons/strike security.png')}}" alt="strike security" class="img-responsive" />
                                </div>
                                <div class="feature-box-info ml-xlg">
                                    <h4 class="mb-sm">Strike Security</h4>
                                    <p>Our professional security personnel are specifically trained to handle special response scenarios with an understandings of legalities of a labor strike or plant closure. Our strike security officers tend to ensure that all assets and personnel are protected so both union officials and management negotiators can resume positive relations once the labor strike has been resolved. </p>
                                   <a class="mt-md" href="{{url('services/strike-security')}}">Learn More <i class="fa fa-long-arrow-right"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>

        </div>
    </div>

</div>
@endsection



<!-- Google Analytics: Change UA-XXXXX-X to be your site's ID. Go to http://www.google.com/analytics/ for more information.
<script>
    (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
    (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
    m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
    })(window,document,'script','//www.google-analytics.com/analytics.js','ga');

    ga('create', 'UA-12345678-1', 'auto');
    ga('send', 'pageview');
</script>
 -->


