@extends('master')
@section('title','Blogs')
@section('keywords','security services, security guards, event security in UAE')
@section('description','Discover the best practices for hospitality security in UAE. Protect your business and guests with our comprehensive guide. Expert tips and insights.')
@section('og:url','https://www.alsafwan.ae/services/hospitality-security')
@section('og:type','services')
@section('og:image','https://www.alsafwan.ae/public/website/img/demos/construction/logo-construction.png')
@section('head')
    <!-- Basic -->
    {{-- <head> --}}

        <!-- Favicons -->
        {{-- <link href="{{ asset('website/assets/img/favicon.png')}}" rel="icon">
        <link href="{{ asset('website/assets/img/apple-touch-icon.png')}}" rel="apple-touch-icon"> --}}

        <!-- Google Fonts -->
        {{-- <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=EB+Garamond:wght@400;500&family=Inter:wght@400;500&family=Playfair+Display:ital,wght@0,400;0,700;1,400;1,700&display=swap" rel="stylesheet"> --}}

        <!-- Vendor CSS Files -->
        <link href="{{ asset('website/assets/vendor/bootstrap/css/bootstrap.min.css')}}" rel="stylesheet">
        <link href="{{ asset('website/assets/vendor/bootstrap-icons/bootstrap-icons.css')}}" rel="stylesheet">
        <link href="{{ asset('website/assets/vendor/swiper/swiper-bundle.min.css')}}" rel="stylesheet">
        <link href="{{ asset('website/assets/vendor/glightbox/css/glightbox.min.css')}}" rel="stylesheet">
        <link href="{{ asset('website/assets/vendor/aos/aos.css')}}" rel="stylesheet">

        <!-- Template Main CSS Files -->
        <link href="{{ asset('website/assets/css/variables.css')}}" rel="stylesheet">
        <link href="{{ asset('website/assets/css/main.css')}}" rel="stylesheet">

        <!-- =======================================================
        * Template Name: ZenBlog
        * Updated: Mar 10 2023 with Bootstrap v5.2.3
        * Template URL: https://bootstrapmade.com/zenblog-bootstrap-blog-template/
        * Author: BootstrapMade.com
        * License: https:///bootstrapmade.com/license/
        ======================================================== -->
      {{-- </head> --}}
@endsection
@section('content')
<section id="hero-slider" class="hero-slider">
    <div class="container-md" data-aos="fade-in">
        <div class="row">
            <div class="col-12">
                <div class="img-bg d-flex align-items-end" style="background-image: url('website/assets/img/post-slide-1.jpg');">
                    <h1 style="position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%);">BLOGS</h1>
                </div>

            </div>
        </div>
    </div>
</section>
  <!-- End Hero Slider Section -->
  <!-- ======= Post Grid Section ======= -->
<section id="posts" class="posts">
    <div class="container" data-aos="fade-up">
        <div class="row g-5">
            <div class="col-lg-9">
                <div class="row g-5">
                    <div class="col-lg-12 border-start custom-border">
                        <div class="row g-5">
                            @foreach ($all_blogs as $blogs)
                                <div class="col-lg-4 border-start custom-border">
                                    <div class="post-entry-1">
                                        <a href="{{url('blog-page-detail',($blogs->id))}}"><img src="{{ $blogs->thumbnail_blog }}" alt="blogs_pictures" class="img-fluid"></a>
                                        <div class="post-meta"><span class="date"></span> <span class="mx-1">&bullet;</span> <span>{{ $blogs->updated_at }}</span></div>
                                        <h2><a href="{{url('blog-page-detail',($blogs->id))}}">{{ $blogs->title }}</a></h2>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
            <!-- Trending Section -->
            <div class="col-lg-3">
                <div class="trending">
                    <h3>Trending</h3>
                    <ul class="trending-post">
                        @foreach ($trending_blogs as $trending_blog)
                            <li>
                                <a href="{{url('blog-page-detail',($trending_blog->id))}}">
                                    {{-- <span class="number">1</span> --}}
                                    <h3>{{ $trending_blog->title }}</h3>
                                    <span class="author">Al Safwan</span>
                                </a>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>
            <!-- End Trending Section -->
        </div>
        </div> <!-- End .row -->
    </div>
</section>
  <!-- End Post Grid Section -->
<div class="body">


<body>

  <!-- ======= Header ======= -->
  {{-- <header id="header" class="header d-flex align-items-center fixed-top">
    <div class="container-fluid container-xl d-flex align-items-center justify-content-between"> --}}

      {{-- <a href="index.html" class="logo d-flex align-items-center">
        <!-- Uncomment the line below if you also wish to use an image logo -->
        <img src="{{ asset('website/assets/img/logo.png')}}" alt="">
        <h1>ZenBlog</h1>
      </a> --}}

      {{-- <nav id="navbar" class="navbar">
        <ul>
          <li><a href="index.html">Blog</a></li>
          <li><a href="single-post.html">Single Post</a></li>
          <li class="dropdown"><a href="category.html"><span>Categories</span> <i class="bi bi-chevron-down dropdown-indicator"></i></a>
            <ul>
              <li><a href="search-result.html">Search Result</a></li>
              <li><a href="#">Drop Down 1</a></li>
              <li class="dropdown"><a href="#"><span>Deep Drop Down</span> <i class="bi bi-chevron-down dropdown-indicator"></i></a>
                <ul>
                  <li><a href="#">Deep Drop Down 1</a></li>
                  <li><a href="#">Deep Drop Down 2</a></li>
                  <li><a href="#">Deep Drop Down 3</a></li>
                  <li><a href="#">Deep Drop Down 4</a></li>
                  <li><a href="#">Deep Drop Down 5</a></li>
                </ul>
              </li>
              <li><a href="#">Drop Down 2</a></li>
              <li><a href="#">Drop Down 3</a></li>
              <li><a href="#">Drop Down 4</a></li>
            </ul>
          </li>

          <li><a href="about.html">About</a></li>
          <li><a href="contact.html">Contact</a></li>
        </ul>
      </nav> --}}
      <!-- .navbar -->

      {{-- <div class="position-relative">
        <a href="#" class="mx-2"><span class="bi-facebook"></span></a>
        <a href="#" class="mx-2"><span class="bi-twitter"></span></a>
        <a href="#" class="mx-2"><span class="bi-instagram"></span></a> --}}

        <a href="#" class="mx-2 js-search-open"><span class="bi-search"></span></a>
        {{-- <i class="bi bi-list mobile-nav-toggle"></i> --}}

        <!-- ======= Search Form ======= -->
        {{-- <div class="search-form-wrap js-search-form-wrap">
          <form action="search-result.html" class="search-form">
            <span class="icon bi-search"></span>
            <input type="text" placeholder="Search" class="form-control">
            <button class="btn js-search-close"><span class="bi-x">Button</span></button>
        </form>
    </div> --}}
    <button class="btn js-search-close"><span class="bi-x"></span></button>
        <!-- End Search Form -->

      {{-- </div>

    </div>

  </header> --}}
  <!-- End Header -->

  <main id="main">

    <!-- ======= Hero Slider Section ======= -->


  </main>
  <!-- End #main -->

  <a href="#" class="scroll-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Vendor JS Files -->
  <script src="{{ asset('website/assets/vendor/bootstrap/js/bootstrap.bundle.min.js')}}"></script>
  <script src="{{ asset('website/assets/vendor/swiper/swiper-bundle.min.js')}}"></script>
  <script src="{{ asset('website/assets/vendor/glightbox/js/glightbox.min.js')}}"></script>
  <script src="{{ asset('website/assets/vendor/aos/aos.js')}}"></script>
  <script src="{{ asset('website/assets/vendor/php-email-form/validate.js')}}"></script>

  <!-- Template Main JS File -->
  <script src="{{ asset('website/assets/js/main.js')}}"></script>

</body>

</html>
</div>

@endsection
