@extends('layouts.adminMaster')
@section('title','Create Category Page')
@section('content')

    <head>
        <meta name="csrf-token" content="{{ csrf_token() }}">
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
        <link rel="shortcut icon" type="image/icon" href="{{ asset('images/favicon.ico') }}"/>
        <!-- Bootstrap -->
        <link href="{{ asset('vendors/bootstrap/dist/css/bootstrap.min.css') }}" rel="stylesheet">
        <!-- Font Awesome -->
        <link href="{{ asset('vendors/font-awesome/css/font-awesome.min.css') }}" rel="stylesheet">
        <!-- NProgress -->
        <link href="{{ asset('vendors/nprogress/nprogress.css') }}" rel="stylesheet">
        <!-- Animate.css -->
        <link href="{{ asset('vendors/animate.css/animate.min.css') }}" rel="stylesheet">
        <!-- iCheck -->
        <link href="{{ asset('vendors/iCheck/skins/square/blue.css') }}" rel="stylesheet">
        <!-- Datatables -->
        <link href="{{ asset('vendors/datatables.net-bs/css/dataTables.bootstrap.min.css') }}" rel="stylesheet">
        <link href="{{ asset('vendors/datatables.net-buttons-bs/css/buttons.bootstrap.min.css') }}" rel="stylesheet">
        <link href="{{ asset('vendors/datatables.net-fixedheader-bs/css/fixedHeader.bootstrap.min.css') }}" rel="stylesheet">
        <link href="{{ asset('vendors/datatables.net-responsive-bs/css/responsive.bootstrap.min.css') }}" rel="stylesheet">
        <link href="{{ asset('vendors/datatables.net-scroller-bs/css/scroller.bootstrap.min.css') }}" rel="stylesheet">

        <!-- Custom Theme Style -->
        <link href="{{ asset('css/custom.min.css') }}" rel="stylesheet">

        <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->

        <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
        <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>

    </head>
    <style>
        #save_inActivate{
            display:none;
            color:green;
            /*width: 1170px;*/
            width: 103.5%;
            margin-left: -19.5px;
        }
        #save_remarks{
            display:none;
            color:green;
            /*width: 1170px;*/
            width: 103.5%;
            margin-left: -19.5px;
        }
        textarea{
            resize: none;
        }
        .modal {
            text-align: center;
            padding: 0!important;
        }
        .modal:before {
            content: '';
            display: inline-block;
            height: 100%;
            vertical-align: middle;
            margin-right: -4px;
        }

        .modal-dialog {
            display: inline-block;
            text-align: left;
            vertical-align: middle;
        }


        .font_size{
            font-size: 16px;
            font-weight: 700;
        }

    </style>
    <!--<div class="color_pick_wrap">		-->
    <!--<div id="color_setting" class="color_settings">			-->
    <!--<a id="color_open_close"><i class="fa fa-cog fa-spin fa-fw"></i></a>-->
    <!--<h2>CHECK OUT OUR OTHER ITEMS</h2><br/>-->
    <!--<div>				-->
    <!--<a target="_blank" href="https://themeforest.net/item/ml-responsive-landing-page/19621229"><img style="width: 100%;" src="images/ml_preview.jpg"/></a>-->
    <!--<hr/>-->
    <!--<a target="_blank" href="https://themeforest.net/item/lifesoon-multipurpose-under-constructioncoming-soon/19669767"><img style="width: 100%;" src="images/lifesoon-preview.jpg"/></a>-->
    <!--<hr/>-->
    <!--<a target="_blank" href="https://themeforest.net/item/lost-in-forest-responsive-error-page/19566645"><img style="width: 100%;" src="images/lostinforest_preview.jpg"/></a>-->
    <!--<hr/>-->
    <!--<a target="_blank" href="https://themeforest.net/item/newenrgy-luxury-landing-html-template/19429040"><img style="width: 100%;" src="images/newenergy_preview.jpg"/></a>-->
    <!--</div>			-->
    <!--</div>	-->
    <!--</div>-->

    <!-- top navigation -->

    <!-- /top navigation -->
    <!-- breadcrumb -->
    <div class="breadcrumb_content" style="background-color: #eef1f5">
        <br>
        {{--<div class="breadcrumb_text"><a href="#">Table</a> / Table Dynamic--}}
    </div>
    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">
            <!--<div class="page-title">-->
            <!--<div class="title_left">-->
            <!--<h3>DataTables jQuery Plugin</h3>-->
            <!--<p>DataTables is a plug-in for the jQuery Javascript library. It is a highly flexible tool, based upon the foundations of progressive enhancement, and will add advanced interaction controls to any HTML table.</p>-->
            <!--<p>For more info click to link <a class="blue" href="http://datatables.net/" target="_blank">official documentation</a></p>-->
            <!--</div>-->
            <!--</div>-->
            <div class="alert alert-success col-sm-12" id="save_inActivate">
                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                <strong>User Deactivate </strong>
            </div>
            <div class="alert alert-success col-sm-12" id="save_remarks">
                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                <strong>Remarks Added Successfully</strong>
            </div>
            <div class="clearfix"></div>

            <div class="row">
                <div class="col-md-12 col-sm-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h4>Create Category Page</h4>
                            <div style="float: right;"><a href="{{url('pageIndex')}}"><button class="btn btn-primary">AlSafwan Index Page</button></a></div>
                            <div class="clearfix"></div>
                        </div>
                        <div class="container">
                            <br>
                            <form action="{{ route('ckeditor.page-store')}}" id="submitform" method="POST" enctype="multipart/form-data">
                                @csrf
                                <div style="width:100%; float:left">
                                    <div style="width:40%; float:left">
                                        <label>Type</label>
                                        <select class='form-control' name="type" id="type">
                                            <option value="">-- Select Type --</option>
                                            <option value="/">HOME</option>
                                            <option value="Services">SERVICES</option>
                                            <option value="Company">COMPANY</option>
                                            <option value="Service-Industries">INDUSTRIES</option>
                                            <option value="Careers">CAREERS</option>
                                            <option value="ContactUs">CONTACT</option>
                                        </select>
                                        <br>
                                    </div>
                                    <div style="width:40%; float:right">
                                        <label>Category</label>
                                        <select class='form-control' name="category" id="category">
                                        </select>
                                    </div>
                                </div>
                                <div style="width:100%; float:left">
                                    <div style="width:40%; float:left">
                                        <label>Slug</label>
                                        <input class='form-control' type='text' name='slug' id='slug'>
                                        <br>
                                    </div>
                                </div>
                                <label>Page Title</label>
                                <input class='form-control' type='text' name='page-title' id='page-title'>
                                <br>
                                <label>Page Detail</label>
                                <textarea class="ckeditor form-control" name="wysiwyg-editor" id="wysiwyg-editor"></textarea>
                                <br>
                                <div style="width:100%; float:left">
                                    <div style="width:40%; float:left">
                                        <label>Meta Title</label>
                                        <input class='form-control' type='text' name='meta-title' id='meta-title'>
                                        <br>
                                    </div>
                                    <div style="width:40%; float:right">
                                        <label>Meta Description</label>
                                        <textarea class='form-control' name='meta-description' id='meta-description' rows="4"></textarea>
                                        <br>
                                    </div>

                                </div>
                                <div style="width:100%; float:left">
                                    <div style="width:40%; float:left">
                                        <label>Meta Keyworks</label>
                                        <input class='form-control' type='text' name='meta-keyworks' id='meta-keyworks'>
                                        <br>
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-success">Submit</button>
                            </form>
                        </div>

                        <script src="https://cdn.ckeditor.com/4.13.0/full/ckeditor.js"></script>
                        <script type="text/javascript" src="{{ asset('ckeditor/ckfinder/ckfinder.js') }}"></script>
                            <script>
                                var editor = CKEDITOR.replace( 'wysiwyg-editor',{
                                    extraPlugins : 'filebrowser',
                                    filebrowserBrowseUrl: 'ckeditor/ckfinder/ckfinder.html',
                                    filebrowserUploadUrl: "{{route('ckeditor.image-upload', ['_token' => csrf_token() ])}}",
                                    filebrowserUploadMethod: 'form'
                                });
                                CKFinder.setupCKEditor( editor );
                                CKEDITOR.config.extraPlugins = 'contextmenu';
                                CKEDITOR.config.extraPlugins = 'dialog';
                                CKEDITOR.config.extraPlugins = 'liststyle';
                                CKEDITOR.config.extraPlugins = 'dialogui';
                                CKEDITOR.config.extraPlugins = 'menu';
                            </script>
                        <script>
                            $(document).ready(function(){

                                $('body').on('submit', '#submitform', function(e){
                                    e.preventDefault();

                                    $.ajax({
                                        url: $(this).attr('action'),
                                        data: new FormData(this),
                                        type: 'POST',
                                        contentType: false,
                                        cache: false,
                                        processData: false,
                                        success: function(data) {
                                            alert(data.msg);
                                            location.reload();

                                        }
                                    });
                                });
                            });
                        </script>
                        <script>
                            $(document).ready(function () {

                                /*------------------------------------------
                                --------------------------------------------
                                Category Dropdown Change Event
                                --------------------------------------------
                                --------------------------------------------*/
                                $('#type').on('change', function () {
                                    var type = this.value;
                                    $("#category").html('');
                                    $.ajax({
                                        url: "{{url('api/mainCategory')}}",
                                        type: "POST",
                                        data: {
                                            luxury: type,
                                            _token: '{{csrf_token()}}'
                                        },
                                        dataType: 'json',
                                        success: function (result) {
                                            $('#category').html('<option value="">-- Select Category --</option>');
                                            $("#category").append('<option value="services/hospitality-security">Hospitality Security</option>');
                                            $("#category").append('<option value="services/security-guard-staffing">Security Guard Staffing</option>');
                                            $("#category").append('<option value="services/event-security">Event Security</option>');
                                            $("#category").append('<option value="services/executive-protection">Executive Protection</option>');
                                            $("#category").append('<option value="services/workplace-protection-and-rif-security">Workplace Protection & RIF Security</option>');
                                            $("#category").append('<option value="services/warehouse-protection">Warehouse Protection</option>');
                                            $("#category").append('<option value="services/strike-security">Strike Security</option>');
                                        }
                                    });
                                });

                                /*------------------------------------------
                                --------------------------------------------
                                Sub_Category Dropdown Change Event
                                --------------------------------------------
                                --------------------------------------------*/
                                // $('#category').on('change', function () {
                                //     var subCategory = this.value;
                                //     $("#sub-category").html('');
                                //     $.ajax({
                                //         url: "{{url('api/subCategory')}}",
                                //         type: "POST",
                                //         data: {
                                //             category_id: subCategory,
                                //             _token: '{{csrf_token()}}'
                                //         },
                                //         dataType: 'json',
                                //         success: function (res) {
                                //             $('#sub-category').html('<option value="" selected>-- Select Sub_Category --</option>');
                                //             $.each(res.data, function (key, value) {
                                //                 $("#sub-category").append('<option value="' + value.id + '">' + value.name + '</option>');
                                //             });
                                //         }
                                //     });
                                // });

                                /*------------------------------------------
                                --------------------------------------------
                                type_id Change Event
                                --------------------------------------------
                                --------------------------------------------*/
                                // $('#type').change(function(){
                                //         $('#type-id').val($(this).find('option:selected').val());
                                // });

                                 /*------------------------------------------
                                --------------------------------------------
                                category_id Change Event
                                --------------------------------------------
                                --------------------------------------------*/
                                // $('#category').change(function(){
                                //         $('#category-id').val($(this).find('option:selected').val());
                                // });

                                /*------------------------------------------
                                --------------------------------------------
                                sub_category_id Change Event
                                --------------------------------------------
                                --------------------------------------------*/
                                // $('#sub-category').change(function(){
                                //         $('#sub-category-id').val($(this).find('option:selected').val());
                                // });
                            });
                        </script>
                    </div>
                </div>

            </div>
        </div>
    </div>

    {{-- <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script> --}}


    <script>
        $(document).ready(function(){
            $(document).on('click', '.delete-modal', function(){
                $('.modal-title').text('Reason For Deactivate');
                $('#addModal').modal('show');
                $('.did').text($(this).data('id'));
            });

            $('.modal-footer').on('click', '.add', function(){
                $.ajax({
                    type: 'POST',
                    url:'statusInActive',
                    data: {
                        '_token': '{{csrf_token()}}',
                        'userId': $('.did').text(),
                        'deactive_reason':$('#content_add').val()
                    },
                    success: function(data){
                        console.log(data);
                        $('#save_inActivate').fadeIn().delay(7000).fadeOut();
                        $('.remove_user' + $('.did').text()).remove();
                    }
                });
            });
        });

    </script>

    <script>
        $(document).ready(function(){
            $(document).on('click', '.add-remarks', function(){
                $('.modal-title').text('Add Remarks');
                $('#RemarksModal').modal('show');
                $('.remarks_did').text($(this).data('id'));
            });

            $('.modal-footer').on('click', '.add', function(){
                $.ajax({
                    type: 'POST',
                    url:'call_status_remarks',
                    data: {
                        '_token': '{{csrf_token()}}',
                        'userId': $('.remarks_did').text(),
                        'remarks_content_add':$('#remarks_content_add').val()
                    },
                    success: function(data){
                        console.log(data);
                        $('#save_remarks').fadeIn().delay(7000).fadeOut();
                        $("#remarks_form")[0].reset();
                    }
                });
            });
        });
    </script>


    <!-- Mirrored from 104.237.3.115/altena/src/tables_dynamic.html by HTTrack Website Copier/3.x [XR&CO'2014], Fri, 28 Jul 2017 10:57:30 GMT -->
@endsection
