import Productitem from '../../app-components/Productitem';
import { AiOutlineDown } from "react-icons/ai";
import { BsFilter, BsFillCaretDownFill, BsChevronDown, BsChevronUp } from "react-icons/bs";
import { FaShippingFast } from "react-icons/fa";
import { TiTick } from "react-icons/ti";
import React, { useEffect, useState, useRef } from 'react';
import axios from "axios";
import Pagination from 'react-bootstrap/Pagination'
import CFooter from '../../app-components/CFooter';
import Typography from '@material-ui/core/Typography';
import Slider from '@material-ui/core/Slider';
import './AllProducts.scss';
import { Link, useHistory } from 'react-router-dom'
import Overlay from 'react-bootstrap/Overlay'
import Popover from 'react-bootstrap/Popover'
import ShimmerC from '../../app-components/ShimmerC';
import Breadcrumbs from '@material-ui/core/Breadcrumbs';
import { globleAPI as Global } from '../../globals'
import girl from '../../assets/emojiwindle.png';
import MultiSelect from '../../app-components/MultiSelect';
import slugify from 'react-slugify';
import HeaderforRetail from '../../app-components/HeaderforRetail';

function AllProducts(props: any) {

  const [PopularProducts, setPopularProducts] = useState([])
  const [show, setShow] = useState(false);
  const [target, setTarget] = useState(null);
  const ref = useRef(null);
  const [Page, setPage] = useState('')
  const [Pagedata, setPagedata] = useState<any>([])
  const [lastPage, setlastPage] = useState('')
  const [colorsList, setcolorsList] = useState([])
  const [brandsList, setbrandsList] = useState([])
  const [NameOfSorting, setNameOfSorting] = React.useState('Newest List');
  const [Price, setPrice] = React.useState([0, 100]);
  const [dataofcheckbox, setdataofcheckbox] = React.useState(false);
  const [loadingTrue, setloadingTrue] = React.useState(false);
  const [AllCategories, setAllCategories] = React.useState([]);
  const [SubCategories, setSubCategories] = React.useState([]);
  const [categoryName, setcategoryName] = React.useState('');
  const [categoryId, setcategoryId] = React.useState('');
  const [subCategory, setsubCategory] = React.useState('');
  const [selectedBrands, setselectedBrands] = React.useState<any>([]);
  const [selectedColors, setselectedColors] = React.useState<any>([]);
  const [selectedSizes, setselectedSizes] = React.useState<any>([]);
  const [ItemonSAle, setItemonSAle] = React.useState<any>([]);
  const [Productconditon, setProductconditon] = React.useState('');
  const [subCategoryName, setsubCategoryName] = React.useState('');
  const [selectedSeleName, setselectedSeleName] = React.useState('');
  const [HighttoLow, setHighttoLow] = React.useState<any>();
  const [lowToHigh, setlowToHigh] = React.useState<any>();
  const [MostPopular, setMostPopular] = React.useState<any>();
  const [NewListed, setNewListed] = React.useState<any>(1);
  const [product_sizes, setproduct_sizes] = React.useState<any>();
  const [oldListed, setoldListed] = React.useState<any>();
  const [lastPageCondition, setlastPageCondition] = React.useState(false);
  const [nextpageNo, setnextpageNo] = React.useState<any>('1');
  const [categoreyFilter, setcategoreyFilter] = React.useState(true);
  const [saleFilter, setsaleFilter] = React.useState(true);
  const [subcategoreyFilter, setsubcategoreyFilter] = React.useState(true);
  const [BrandsFilter, setBrandsFilter] = React.useState(true);
  const [sizesFilter, setsizesFilter] = React.useState(false);
  const [noProduct, setnoProduct] = React.useState(false);
  const [cOlorsFilter, setcOlorsFilter] = React.useState(true);
  const [sortingTick, setsortingTick] = React.useState('');
  const [Itemsale, setItemsale] = React.useState('');
  const [PropsData, setPropsData] = React.useState<any>('');
  const [ItemonSaleValue, setItemonSaleValue] = React.useState<any>('');
  const [BrandsDataBEforeSearch, setBrandsDataBEforeSearch] = React.useState<any>([]);
  const [ConditionFilter, setConditionFilter] = React.useState(true);
  const [NoProductStatus, setNoProductStatus] = React.useState(false);
  const [token, settoken] = useState(localStorage.getItem('token') || '')
  const history = useHistory();

  useEffect(() => {
    history.listen((location, action) => {
      window.location.reload();
      window.scrollTo(0, 0)
    })
    window.scrollTo(0, 0)
    setloadingTrue(true)
    getAllProducts();
    getColors()
    getBrands()
    getfilters()
    GetSaleFilters()

  }, []);

  const methodMultiselect = (data: any, data2: any) => {
    if (data2 == 'brands') {
      setselectedBrands(data)
      getrelatedData(categoryId, subCategory, data, Productconditon, Price, 1, Itemsale, selectedColors, selectedSizes, ItemonSaleValue)
    } else if (data2 == 'colors') {
      setselectedColors(data)
      getrelatedData(categoryId, subCategory, selectedBrands, Productconditon, Price, 1, Itemsale, data, selectedSizes, ItemonSaleValue)
    } else if (data2 == 'sizes') {
      setselectedSizes(data)
      getrelatedData(categoryId, subCategory, selectedBrands, Productconditon, Price, 1, Itemsale, selectedColors, data, ItemonSaleValue)
    }
  }

  const GetSaleFilters = () => {
    axios
      .get(Global.GetSaleFilters)
      .then(response => {
        if (props.location.state[0] == 'AllSale') {
          response.data.store_filters && response.data.store_filters.forEach((item: any) => item.checked = false);
          let selected: any;
          selected = response.data.store_filters.find((item: any) => item.name === 'See All');
          selected.checked = !selected.checked;
          setItemonSAle(response.data.store_filters)
        } else {
          setItemonSAle(response.data.store_filters)
          console.log('response.data.store_filters', response.data.store_filters)
        }

      })
      .catch(function (error) {
        console.log('response of the api ', error)
      });
  }

  const AllProduct = (page: any) => {
    window.scrollTo(0, 0)
    axios
      .get(Global.WebGetAllProductsV1 + '?page=' + page)
      .then(response => {
        setPopularProducts(response.data.AllProducts.data)
        if (response.data.AllProducts.total == '0') {
          setNoProductStatus(true)
        } else {
          setNoProductStatus(false)
        }
        setPage(response.data.AllProducts.current_page)
        setPagedata(response.data.AllProducts)
        setlastPage(response.data.AllProducts.last_page)
        setloadingTrue(false)
      })
      .catch(function (error) {
        console.log('response of the api ', error)
      });
  }

  const AllProductsearched = (searchkeyWord: any) => {
    window.scrollTo(0, 0)
    axios
      .post(Global.WebSearchFromAllProducts + "?search_keyword=" + searchkeyWord + "&is_luxury=0",)
      .then(response => {
        setPopularProducts(response.data.AllProducts.data)
        if (response.data.AllProducts.data.length == '0') {
          setNoProductStatus(true)
        } else {
          setNoProductStatus(false)
        }
        setloadingTrue(false)
      })
      .catch(function (error) {
        console.log('rdskflsdfkapi ', error)
      });
  }

  const getAllProducts = () => {
    if (props.location.state[0] == 'AllProducts') {
      getrelatedData(categoryId, subCategory, selectedBrands, Productconditon, Price, 1, 'No', selectedColors, selectedSizes, ItemonSaleValue)
      getAllCategoriesN()
    } else if (props.location.state[0] == 'AllSale') {
      getAllCategoriesN()
      setItemsale('Yes')
      getrelatedData(categoryId, subCategory, selectedBrands, Productconditon, Price, 1, 'Yes', selectedColors, selectedSizes, ItemonSaleValue)
    } else if (props.location.state[0] == 'AllCat') {
      getAllCategories()
      setItemsale('Yes')
      getrelatedData(props.location.state[1], subCategory, selectedBrands, Productconditon, Price, 1, 'Yes', selectedColors, selectedSizes, ItemonSaleValue)

    } else if (props.location.state[0] == 'AllCatSubCat') {
      getAllCategories()
      setcategoryId(props.location.state[1])
      getsubCategory(props.location.state[1])
      setsubCategory(props.location.state[2])
      getrelatedData(props.location.state[1], props.location.state[2], selectedBrands, Productconditon, Price, 1, Itemsale, selectedColors, selectedSizes, ItemonSaleValue)

    } else if (props.location.state[0] == 'itemCat') {
      getsubCategory(props.location.state[1])
      setcategoryId(props.location.state[1])
      getAllCategories()
      getrelatedData(props.location.state[1], subCategory, selectedBrands, Productconditon, Price, 1, Itemsale, selectedColors, selectedSizes, ItemonSaleValue)

    } else if (props.location.state[0] == 'usedItems') {
      setProductconditon('Used')
      getAllCategoriesN()
      getrelatedData(categoryId, subCategory, selectedBrands, "Used", Price, 1, Itemsale, selectedColors, selectedSizes, ItemonSaleValue)

    } else if (props.location.state[0] == 'AllSalePercentage') {
      getAllCategoriesN()
      setItemsale('Yes')
      setItemonSaleValue(props.location.state[1])
      getrelatedData(categoryId, subCategory, selectedBrands, Productconditon, Price, 1, 'Yes', selectedColors, selectedSizes, props.location.state[1])
    } else if (props.location.state[0] == 'searchData') {
      getAllCategoriesN()
      AllProductsearched(props.location.state[1])
    } else if (props.location.state[0] == 'AllSaleSpecificPercentage') {
      getsubCategory(props.location.state[2])
      setcategoryId(props.location.state[2])
      getAllCategories()
      setItemsale('Yes')
      setItemonSaleValue(props.location.state[1])
      getrelatedData(props.location.state[2], subCategory, selectedBrands, Productconditon, Price, 1, 'Yes', selectedColors, selectedSizes, props.location.state[1])
    }

  }

  const getSortingData = (ph: any, pl: any, lh: any, hl: any, mp: any) => {
    axios.post(Global.WebSearchFromAllProducts + '?page=' + 1, {
      is_luxury: 0,
      parent_category_id: categoryId,
      category_id: subCategory,
      sizes: selectedSizes,
      discount: ItemonSaleValue,
      manufacturer_names: selectedBrands,
      colors: selectedColors,
      product_condition: Productconditon,
      price_from: Price[0] * 50,
      price_to: Price[1] * 50,
      item_on_sale: Itemsale,
      price_high_to_low: ph,
      price_low_to_high: pl,
      latest_to_old: lh,
      old_to_lates: hl,
      most_popular: mp,
    })
      .then(response => {
        window.scrollTo(0, 0)
        setPopularProducts(response.data.AllProducts.data)
        if (response.data.AllProducts.total == '0') {
          setNoProductStatus(true)
        } else {
          setNoProductStatus(false)
        }
        setlastPage(response.data.AllProducts.last_page)
        setPage(response.data.AllProducts.current_page)
        setPagedata(response.data.AllProducts)
        setloadingTrue(false)

      })
      .catch(function (error) {
        console.log('response if the api is errror =', error)
      });

  }

  const getrelatedData = (catId: any, subCatId: any, brands: any, conditon: any, price: any, page: any, itemsale: any, colors: any, sizes: any, discount: any) => {

    axios.post(Global.WebSearchFromAllProducts + '?page=' + page, {
      is_luxury: 0,
      parent_category_id: catId,
      category_id: subCatId,
      sizes: sizes,
      discount: discount,
      manufacturer_names: brands,
      colors: colors,
      product_condition: conditon,
      price_from: price[0] * 50,
      price_to: price[1] * 50,
      most_popular: MostPopular,
      item_on_sale: itemsale,
      latest_to_old: NewListed,
      old_to_lates: oldListed,
      price_low_to_high: lowToHigh,
      price_high_to_low: HighttoLow,
    })
      .then(response => {
        window.scrollTo(0, 0)
        setPopularProducts(response.data.AllProducts.data)
        if (response.data.AllProducts.total == '0') {
          setNoProductStatus(true)
        } else {
          setNoProductStatus(false)
        }
        setlastPage(response.data.AllProducts.last_page)
        setPage(response.data.AllProducts.current_page)
        setPagedata(response.data.AllProducts)
        setloadingTrue(false)

      })
      .catch(function (error) {
        console.log('response if the api is errror =DDDDDDD', error)
      });

  }

  const getAllCategoriesN = () => {
    axios
      .get(Global.GET_ALL_CATEGORIES + "?luxury=" + 0 + "&regular=" + 1,)
      .then(response => {
        setAllCategories(response.data.categories)

      })
      .catch(function (error) {
        console.log('no is showing or not', error)
      });
  };

  const getAllCategories = () => {
    axios
      .get(Global.GET_ALL_CATEGORIES + "?luxury=" + 0 + "&regular=" + 1,)
      .then(response => {
        response.data.categories && response.data.categories.forEach((item: any) => item.checked = false);
        let selected: any;
        selected = response.data.categories.find((item: any) => item.id === (props.location.state[1]) || (props.location.state[2]));
        selected.checked = !selected.checked;
        setcategoryName(selected.name)
        setAllCategories(response.data.categories)


      })
      .catch(function (error) {
        console.log('no is showing or not', error)
      });
  };

  const getsubCategory = (id: any) => {
    axios
      .get(Global.GET_ALL_SUB_CATEGORIES + "?parent_category=" + id)
      .then(response => {
        if (props.location.state[2] != undefined) {
          response.data.subcategories && response.data.subcategories.forEach((item: any) => item.checked = false);
          let selected: any;
          selected = response.data.subcategories.find((item: any) => item.id === props.location.state[2]);
          selected.checked = !selected.checked;
          setsubCategoryName(selected.name)
          setSubCategories(response.data.subcategories)
        } else {
          setSubCategories(response.data.subcategories)
        }

      })
      .catch(function (error) {
        console.log('responnnse of cate', error)
      });
  }

  const getfilters = () => {
    if (props.location.state == 'Sop All') {
      setdataofcheckbox(true)
    }
  }

  const getColors = () => {
    axios
      .get(Global.GET_ALL_COLOR + "?is_luxury=0")
      .then(response => {
        response.data.colors && response.data.colors.forEach((item: any) => item.checked = false);
        setcolorsList(response.data.colors)
      })
      .catch(function (error) {
        console.log('resofsodf', error)
      });
  }

  const getBrands = () => {
    axios
      .get(Global.GET_BRAND_FILTER + "?luxury=0&regular=1")
      .then(response => {
        response.data.brands && response.data.brands.forEach((item: any) => item.checked = false);
        setbrandsList(response.data.brands);
        setBrandsDataBEforeSearch(response.data.brands)
      })
      .catch(function (error) {
        console.log('response if the api is errror =', error)
      });
  }

  const getAllSizes = (cat_id: any) => {
    console.log('Global.GET_ALL_SIZES + "?category_id" + cat_id + "&is_luxury=0"', Global.GET_ALL_SIZES + "?category_id=" + cat_id + "&is_luxury=0")
    axios
      .get(Global.GET_ALL_SIZES + "?category_id=" + cat_id + "&is_luxury=0")
      .then(response => {
        setproduct_sizes(response.data.product_sizes);
        setsizesFilter(true)
      })
      .catch(function (error) {
        console.log('responseresponseresponse', error)
      });
  }

  const Paginationfunction = (page: any) => {
    if (props.location.state[1] == '118' && categoryId == '' && subCategory == '' && selectedBrands == '' && Productconditon == '' && Itemsale == '' && selectedColors == '' && ItemonSaleValue == '' && selectedSizes == '') {
      AllProduct(page)
    } else {
      getrelatedData(categoryId, subCategory, selectedBrands, Productconditon, Price, page, Itemsale, selectedColors, selectedSizes, ItemonSaleValue)
    }
  }

  const RiChecke = (page: any) => {
    let data
    if (page == 'NextPage') {
      if (lastPage > Page) {
        data = Page + 1
        Paginationfunction(data)
      } else {
        data = lastPage
        setlastPageCondition(true)
      }
      data = data
    } else if (page == 'PreviousPage') {
      let dataofnextPage: any = Page;
      dataofnextPage = dataofnextPage - 1
      if (dataofnextPage >= 1) {
        Paginationfunction(dataofnextPage)
      } else {
        console.log('reached 1st page')
      }

      data = dataofnextPage
    } else {
      setnextpageNo(page)
      Paginationfunction(page)
    }
  }

  const rangeSelector = (event: object, newValue: any) => {
    setPrice(newValue);
    getrelatedData(categoryId, subCategory, selectedBrands, Productconditon, newValue, nextpageNo, Itemsale, selectedColors, selectedSizes, ItemonSaleValue)

  };

  const CgRadioCheck = (name: any) => {
    AllCategories && AllCategories.forEach((item: any) => item.checked = false);
    let selected: any;
    selected = AllCategories.find((item: any) => item.id === name.id);
    selected.checked = !selected.checked;
    setcategoryName(name.name)
    setcategoryId(name.id)
    getsubCategory(name.id)
    setPropsData('')
    getrelatedData(name.id, subCategory, selectedBrands, Productconditon, Price, 1, Itemsale, selectedColors, selectedSizes, ItemonSaleValue)
    setsubCategory('')
  }

  const getSubCategoryAPI = (name: any) => {
    SubCategories && SubCategories.forEach((item: any) => item.checked = false);
    let selected: any;
    selected = SubCategories.find((item: any) => item.id === name.id);
    selected.checked = !selected.checked;
    setsubCategory(name.id)
    setsubCategoryName(name.name)
    getAllSizes(name.id)
    getrelatedData(categoryId, name.id, selectedBrands, Productconditon, Price, 1, Itemsale, selectedColors, selectedSizes, ItemonSaleValue)
  }

  const getCondition = (name: any) => {
    setProductconditon(name)
    getrelatedData(categoryId, subCategory, selectedBrands, name, Price, nextpageNo, Itemsale, selectedColors, selectedSizes, ItemonSaleValue)
  }

  const moveToDetailScreen = (data: any) => {
    // window.open('/product-detail/' + data.id + '/' + slugify(data.name));
    window.open('/product-detail?id='+data.id+'&name='+slugify(data.name))
  }

  const clearFilters = () => {
    window.location.reload();
    AllProduct(1)
  }

  const CheckSale = (data: any) => {
    ItemonSAle && ItemonSAle.forEach((item: any) => item.checked = false);
    let selected: any;
    selected = ItemonSAle.find((item: any) => item.name === data.name);
    selected.checked = !selected.checked;
    setselectedSeleName(data.name)
    setItemsale('Yes')
    setItemonSaleValue(data.discount)
    getrelatedData(categoryId, subCategory, selectedBrands, Productconditon, Price, 1, 'Yes', selectedColors, selectedSizes, data.discount)
  }

  const handleClick = (event: any) => {
    setShow(!show);
    setTarget(event.target);
  };

  const Sorting = (data: any) => {
    setsortingTick(data)
    if (data == 'hl') {
      setNameOfSorting('Highest Price')
      setHighttoLow(1)
      setlowToHigh(0)
      setMostPopular(0)
      setNewListed(0)
      setoldListed(0)
      getSortingData(1, 0, 0, 0, 0)
      setShow(!show);
    } else if (data == 'lh') {
      setNameOfSorting('Lowest Price')
      setHighttoLow(0)
      setlowToHigh(1)
      setMostPopular(0)
      setNewListed(0)
      setoldListed(0)
      getSortingData(0, 1, 0, 0, 0)
      setShow(!show);
    } else if (data == 'mp') {
      setNameOfSorting('Popular Product')
      setHighttoLow(0)
      setlowToHigh(0)
      setMostPopular(1)
      setNewListed(0)
      setoldListed(0)
      getSortingData(0, 0, 0, 0, 1)
      setShow(!show);
    } else if (data == 'nl') {
      setNameOfSorting('Latest Product')
      setHighttoLow(0)
      setlowToHigh(0)
      setMostPopular(0)
      setNewListed(1)
      setoldListed(0)
      getSortingData(0, 0, 1, 0, 0)
      setShow(!show);
    } else if (data == 'ol') {
      setNameOfSorting('Oldest Product')
      setHighttoLow(0)
      setlowToHigh(0)
      setMostPopular(0)
      setNewListed(0)
      setoldListed(1)
      getSortingData(0, 0, 0, 1, 0)
      setShow(!show);
    }
  };

  const Filters = (filter: any) => {
    if (filter == 'categorey') {
      if (categoreyFilter == true) {
        setcategoreyFilter(false)
      } else {
        setcategoreyFilter(true)
      }
    } else if (filter == 'subcategorey') {
      if (subcategoreyFilter == true) {
        setsubcategoreyFilter(false)
      } else {
        setsubcategoreyFilter(true)
      }
    } else if (filter == 'brands') {
      if (BrandsFilter == true) {
        setBrandsFilter(false)
      } else {
        setBrandsFilter(true)
      }
    }
    else if (filter == 'colors') {
      if (cOlorsFilter == true) {
        setcOlorsFilter(false)
      } else {
        setcOlorsFilter(true)
      }
    } else if (filter == 'condition') {
      if (ConditionFilter == true) {
        setConditionFilter(false)
      } else {
        setConditionFilter(true)
      }
    } else if (filter == 'sizes') {
      if (sizesFilter == true) {
        setsizesFilter(false)
      } else {
        setsizesFilter(true)
      }
    } else if (filter == 'sale') {
      if (saleFilter == true) {
        setsaleFilter(false)
      } else {
        setsaleFilter(true)
      }
    }
  }

  const find = (data: any) => {
    if (data == '') {
      setbrandsList(BrandsDataBEforeSearch);
    } else {
      let searchThrough: any = [];
      BrandsDataBEforeSearch.map((item: any) => {
        const check = item.name.toLowerCase().includes(
          data.toLowerCase(),
        );
        if (check == true) searchThrough.push(item);
        else setnoProduct(true);
      });
      setbrandsList(searchThrough);
    }
  };

  return (
    <div>
      <HeaderforRetail />
      <div className='mobiledisplay ' style={{}}>
        <div className=' flex-row d-flex  justify-content-between cp-t-10 cp-b-10 border-bottom cp-8' >
          <div className=' d-flex flex-row align-items-center' >
            <p className='label cp-r-5 f-14 main-font' style={{ color: 'gray' }} >Best Match</p>
            <BsFillCaretDownFill size='11.5' />
          </div>
          <div className=' d-flex flex-row align-items-center' >
            <p className='label cp-r-5 f-14 main-font' style={{ color: 'gray' }} >Free</p>
            <FaShippingFast className='f-25 f-700 cp-r-5' />
            <p className='label cp-r-5 f-14 main-font' style={{ color: 'gray' }} >Filters</p>
            <BsFilter className='f-25 f-700 cp-r-5' />
          </div>
        </div>
        <img style={{ height: '20vh', width: '100%', marginTop: '1%' }} src='data:image/jpeg;base64,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'></img>
        <label className='main-font cp-t-25 f-25 cm-10' style={{ fontWeight: 'bold' }} >Popular Products</label>
      </div>
      <div className='col-12 d-flex  '  >
        <div className='col-md-3 webdisplay col-lg-3 cm-t-10 ' >
          <div className="d-flex flex-column" >
            {props.location.state[1] == 'All Deals' ? (<label className="form-check-label secHeading primary-color  cp-l-35 cp-t-10 label main-font" >All Deals</label>) : (<label className="form-check-label secHeading   cp-l-35 cp-t-10 label main-font" style={{ color: 'white' }} >All Deals</label>)}
            <label className="form-check-label f-13  cp-l-35 cp-t-52 cp-b-10 label main-font " style={{ color: 'gray' }} >Filter by</label>
          </div>
          <div className='cp-l-30 border-top' >
            <div className='d-flex justify-content-between cp-b-15 cp-t-15' >
              <label className='main-font  f-17 f-500 label text-color ' style={{}} >Categories</label>
              <div className='cp-r-35' onClick={() => Filters('categorey')} >
                {categoreyFilter == true ? (
                  <BsChevronUp className='f-10  ' />
                ) : (
                  <BsChevronDown className='f-10  ' />
                )
                } </div>
            </div>
            {categoreyFilter == true ? (
              <div>
                {AllCategories.length >= 1 ? (
                  <div>
                    {AllCategories.map((category: any, index) =>
                      <div className='d-flex  align-items-center cp-t-4 cp-b-4' >
                        <input type="radio" onClick={() => CgRadioCheck(category)} checked={category.checked} className='largerCheckbox touchAble' id="Category" name="gender" value="male" />
                        <label className="form-check-label f-13  cp-l-15 label main-font " style={{ color: 'gray' }} >{category.name}</label>
                        <label className="form-check-label f-13  cp-l-5 label  main-font" style={{ color: 'gray' }} >({category.count})</label>
                      </div>
                    )}
                  </div>
                ) : (
                  <ShimmerC allproductsFilters='yes' />
                )}
              </div>
            ) : null}
          </div>
          {SubCategories.length >= 1 ? (
            <div className='border-top cm-t-20 cm-b-20 cp-l-30' >
              <div className='d-flex justify-content-between cp-b-15 cp-t-15' >
                <label className='main-font  f-17 f-500 label text-color ' style={{}} >Sub Categorey</label>
                <div className='cp-r-35' onClick={() => Filters('subcategorey')} >
                  {subcategoreyFilter == true ? (
                    <BsChevronUp className='f-10' />
                  ) : (
                    <BsChevronDown className='f-10' />
                  )
                  } </div>
              </div>
              {subcategoreyFilter == true ? (
                <div>
                  {SubCategories.length >= 1 ? (
                    <div>
                      {SubCategories.map((Subcategory: any) =>
                        <div className='d-flex center align-items-center cp-t-4 cp-b-4 ' >
                          <input type="radio" onClick={() => getSubCategoryAPI(Subcategory)} checked={Subcategory.checked} className='largerCheckbox touchAble' id="SUbcategory" name="subCat" value="subCat" />
                          <label className="form-check-label f-13 cp-l-15  label main-font" style={{ color: 'gray' }} >{Subcategory.name}</label>
                          <label className="form-check-label f-13  cp-l-5 label main-font" style={{ color: 'gray' }} >({Subcategory.count})</label>
                        </div>
                      )}
                    </div>
                  ) : (
                    <ShimmerC allproductsFilters='yes' />
                  )}
                </div>
              ) : null}
            </div>
          ) : null
          }
          {product_sizes?.length >= 1 ? (
            <div className=' border-top cm-t-20 cm-b-20 cp-l-30' >
              {sizesFilter == true ? (
                <div>
                  <div className='d-flex justify-content-between cp-b-15 cp-t-15' >
                    <label className='main-font  f-17 f-500 label text-color '>Sizes</label>
                    <div className='cp-r-35' onClick={() => Filters('sizes')} >
                      {sizesFilter == true ? (
                        <BsChevronUp className='f-10' />
                      ) : (
                        <BsChevronDown className='f-10' />
                      )
                      } </div>
                  </div>
                  {product_sizes?.length >= 1 ? (
                    <div className='d-flex flex-column'  >

                      <div className='overflow-auto' >
                        <MultiSelect method={methodMultiselect} data={product_sizes} for="sizes" />
                      </div>
                    </div>
                  ) : null}
                </div>
              ) : null}
            </div>
          ) : null}
          <div className='border-top cm-t-20 cm-b-20 cp-l-30' >
            <div className='d-flex justify-content-between cp-b-15 cp-t-15' >
              <label className='main-font  f-17 f-500 label text-color '>Brands</label>
              <div className='cp-r-35' onClick={() => Filters('brands')} >
                {BrandsFilter == true ? (
                  <BsChevronUp className='f-10' />
                ) : (
                  <BsChevronDown className='f-10' />
                )
                } </div>
            </div>
            {BrandsFilter == true ? (
              <div>
                <div className='border cp-5 cm-b-19 ' style={{ borderRadius: 5, width: '95%' }} >
                  <input className='inputsearch' type="text" placeholder="Search.." onChange={(text: any) => { find(text.target.value) }} name="search" />
                </div>
                {brandsList.length >= 1 ? (
                  <div className='d-flex flex-column' style={{ height: '45vh' }} >

                    <div className='overflow-auto' >
                      <MultiSelect method={methodMultiselect} data={brandsList} for="brands" />
                    </div>
                  </div>
                ) : (
                  <div>
                    {noProduct == true ? (
                      <label className='main-font  pText label text-color  cp-l-10'>No Brands found</label>
                    ) : (
                      <ShimmerC allproductsFilters='yes' />
                    )}
                  </div>
                )}
              </div>
            ) : null}
          </div>
          <div className='border-top cm-t-20 cm-b-20 cp-l-30' >
            <div className='d-flex justify-content-between cp-b-15 cp-t-15' >
              <label className='main-font  f-17 f-500 label text-color '>Colors</label>
              <div className='cp-r-35' onClick={() => Filters('colors')} >
                {cOlorsFilter == true ? (
                  <BsChevronUp className='f-10' />
                ) : (
                  <BsChevronDown className='f-10' />
                )
                } </div>
            </div>
            {cOlorsFilter == true ? (
              <div>
                {colorsList?.length >= 1 ? (
                  <div className='d-flex flex-column    ' style={{ height: '45vh' }} >
                    <div className='border cp-5 cm-b-19 ' style={{ borderRadius: 5, width: '95%' }} >
                      <input className='inputsearch' type="text" placeholder="Search.." name="search" />
                    </div>
                    <div className='overflow-auto' >
                      <MultiSelect method={methodMultiselect} data={colorsList} for="colors" />
                    </div>
                  </div>
                ) : (
                  <ShimmerC allproductsFilters='yes' />
                )}
              </div>
            ) : null}
          </div>
          <div className='d-flex flex-column border-top cm-b-20 cp-l-30' >
            <div className='d-flex justify-content-between cp-b-15 cp-t-15' >
              <label className='main-font  f-17 f-500 label text-color '>Condition</label>
              <div className='cp-r-35' onClick={() => Filters('condition')} >
                {ConditionFilter == true ? (
                  <BsChevronUp className='f-10  ' />
                ) : (
                  <BsChevronDown className='f-10  ' />
                )
                } </div>
            </div>
            {ConditionFilter == true ? (
              <div className=" flex-column" >
                <div className='d-flex center align-items-center cp-t-4 cp-b-4' >
                  <input type="radio" onClick={() => getCondition('New')} className='largerCheckbox touchAble' id="new" name="new" value="new" />
                  <label className="form-check-label f-14  cp-l-15 label main-font" style={{ color: 'gray' }} >New</label>
                </div>
                <div className='d-flex center align-items-center cp-t-4 cp-b-4' >
                  <input type="radio" onClick={() => getCondition('Used')} className='largerCheckbox touchAble' id="new" name="new" value="new" />
                  <label className="form-check-label f-14  cp-l-15 label main-font" style={{ color: 'gray' }} >Used</label>
                </div>
              </div>
            ) : null}
          </div>
          <div className='d-flex flex-column border-top cm-t-20 cm-b-20 cp-l-30' >
            <label className='main-font  f-17 f-500 label text-color cp-t-15 cp-b-15' style={{}} >Price</label>
            <div className="form-check col-12  d-flex align-content-center  justify-content-between flex-column" >
              <div style={{
                display: 'block',
                width: 'fit-content'
              }}>
                <Typography id="range-slider" gutterBottom>
                  <p className="text-muted text-center  pText" >Select Price Range:</p>
                </Typography>
                <Slider
                  style={{ color: 'rgb(218, 95, 115)' }}
                  value={Price}
                  onChange={rangeSelector}
                />
                <p className="text-muted text-center  pText" >price  {Price[0] * 50} and {Price[1] * 50}</p>
              </div>
            </div>
          </div>
          <div className='cp-l-30 border-top' >
            <div className='d-flex justify-content-between cp-b-15 cp-t-15' >
              <label className='main-font  f-17 f-500 label text-color ' style={{}} >Item on Sale</label>
              <div className='cp-r-35' onClick={() => Filters('sale')} >
                {saleFilter == true ? (
                  <BsChevronUp className='f-10  ' />
                ) : (
                  <BsChevronDown className='f-10  ' />
                )
                } </div>
            </div>
            {saleFilter == true ? (
              <div>
                {ItemonSAle.length >= 1 ? (
                  <div>
                    {ItemonSAle.map((sale: any) =>
                      <div className='d-flex  align-items-center cp-t-4 cp-b-4' >
                        <input type="radio" onClick={() => CheckSale(sale)} checked={sale.checked} className='largerCheckbox touchAble' />
                        <label className="form-check-label f-13  cp-l-15 label main-font " style={{ color: 'gray' }} >{sale.name}</label>
                      </div>
                    )}
                  </div>
                ) : (
                  <ShimmerC allproductsFilters='yes' />
                )}
              </div>
            ) : null}

          </div>
        </div>
        <div className='col-md-9 col-12 col-lg-9' style={{}} >
          <div className='webdisplay ' >
            <div className='  flex-column d-flex'>
              <div className="cm-t-30 cm-b-30" >
                <Breadcrumbs separator="›" aria-label="breadcrumb">
                  <Link style={{ color: 'black' }} className="main-font" to="/">Home</Link>
                  <Typography className="primary-color main-font" color="textPrimary">Shop All</Typography>
                  <Typography className="primary-color main-font" color="textPrimary">{props.location.state[0] == '118' ? 'All Products ' : 'All Products'}</Typography>
                  {categoryName != '' ? (<Typography className="primary-color main-font" color="textPrimary">{categoryName}</Typography>) : null}
                  {subCategoryName != '' ? (<Typography className="primary-color main-font" color="textPrimary">{subCategoryName}</Typography>) : null}
                </Breadcrumbs>
              </div>
              {categoryName != '' || Price[0] > 1 || selectedSeleName != '' || Productconditon !== '' &&
                <label className='main-font cp-t-10  pText d-flex flex-row ' style={{ color: 'gray' }} >Searched Filters<p className='primary-color cp-l-5  pText' > {categoryName} /</p> <p className='primary-color cp-l-5 cp-r-5 pText' >{subCategoryName}</p>  {Price[0] > 1 ? (<p className='border cp-l-5 cp-r-5 primary-color pText' style={{ borderRadius: 100, }} > / {'  Price  ' + Price[0] * 50} - {Price[1] * 50}</p>) : null} <p className='primary-color  cp-r-5 pText' >{selectedSeleName}</p> <p className='primary-color cp-l-5  pText' > {Productconditon} /</p>   <p className="touchAble underline" style={{ color: 'black', display: 'flex', flexDirection: 'row', marginLeft: '0.5%', alignSelf: 'center' }} onClick={() => clearFilters()} > Clear All </p> </label>
              }
              <div className='d-flex flex-row justify-content-between'>
                <label className='main-font  f-15 f-500 d-flex flex-row' style={{ color: 'gray' }} ><p className='primary-color cp-l-10 cp-r-10 f-600 main-font' ></p> </label>
                <div className='d-flex flex-row ' >
                  <label className='main-font  f-15 f-500 d-flex flex-row label align-items-center ' style={{ color: 'gray', height: '4.5vh' }} >Sort By:</label>
                  <div onClick={handleClick} className='touchAble border cp-l-20  cp-r-20 justify-content-between d-flex flex-row  align-items-center cm-l-5 cm-r-20 ' style={{ height: '4.5vh' }}>
                    <label className='main-font  f-15 f-500 label text-color touchAble cp-r-4'>{<label className='main-font  f-15 f-500 label text-color touchAble cp-r-4'  >{NameOfSorting}</label>}</label>
                    <AiOutlineDown />
                  </div>
                  <Overlay
                    show={show}
                    target={target}
                    placement="bottom"
                    container={ref.current}
                    containerPadding={50}
                  >
                    <Popover style={{ width: '100%', marginTop: '1.5%' }} id="popover-contained">
                      <Popover.Content >
                        <div onClick={() => Sorting('mp')} className=' cp-10 border-bottom d-flex justify-content-between' >
                          <label className='touchAble f-15 f-500 main-font cp-l-10 label' >Most Popular</label>
                          {sortingTick == 'mp' ? (
                            <TiTick size={25} />
                          ) : null}
                        </div>
                        <div onClick={() => Sorting('nl')} className='cp-10 border-bottom d-flex justify-content-between' >
                          <label className='touchAble f-15 f-500 main-font cp-l-10 label' >Newest List</label>
                          {sortingTick == 'nl' ? (
                            <TiTick size={25} />
                          ) : null}
                        </div>
                        <div onClick={() => Sorting('ol')} className='cp-10 border-bottom d-flex justify-content-between' >
                          <label className='touchAble f-15 f-500 main-font cp-l-10 label' >Oldest List</label>
                          {sortingTick == 'ol' ? (
                            <TiTick size={25} />
                          ) : null}
                        </div>
                        <div onClick={() => Sorting('hl')} className='cp-10 border-bottom d-flex justify-content-between' >
                          <label className='f-15 f-500 main-font cp-l-10 label touchAble' >Price High To Low</label>
                          {sortingTick == 'hl' ? (
                            <TiTick size={25} />
                          ) : null}
                        </div>
                        <div onClick={() => Sorting('lh')} className='cp-10 border-bottom d-flex justify-content-between' >
                          <label className='touchAble f-15 f-500 main-font cp-l-10 label' >Price Low To Hight  </label>
                          {sortingTick == 'lh' ? (
                            <TiTick size={25} />
                          ) : null}
                        </div>
                      </Popover.Content>
                    </Popover>
                  </Overlay>
                  {PopularProducts.length >= 1 ? (
                    <div className=' cp-r-25 '  >
                      <Pagination size="sm" >
                        {Pagedata.current_page > '1' ? (<Pagination.Prev onClick={() => RiChecke('PreviousPage')} />) : null}
                        <Pagination.Item onClick={() => RiChecke(1)} >{1}</Pagination.Item>
                        {Pagedata.last_page > '1' ? (<Pagination.Item onClick={() => RiChecke(2)} >{2}</Pagination.Item>) : null}
                        {Pagedata.last_page > '2' ? (<Pagination.Item onClick={() => RiChecke(3)} >{3}</Pagination.Item>) : null}
                        {Pagedata.last_page > '3' ? (<Pagination.Item onClick={() => RiChecke(4)} >{4}</Pagination.Item>) : null}
                        {Pagedata.last_page > '4' ? (<Pagination.Ellipsis />) : null}
                        {Pagedata.last_page > '5' ? (<Pagination.Item onClick={() => RiChecke(Pagedata.last_page)} >{Pagedata.last_page}</Pagination.Item>) : null}
                        {Pagedata.last_page > '5' ? (<Pagination.Next onClick={() => RiChecke('NextPage')} />) : null}
                      </Pagination>
                    </div>
                  ) : null}
                </div>
              </div>
            </div>
          </div>

          {PopularProducts.length >= 1 &&
            <div className='row cp-r-30 ' >
              {PopularProducts.map((data: any) => (
                <div className='col-md-3 col-6  ' onClick={() => moveToDetailScreen(data)}   >
                  <Productitem DataofProduct={data} />
                </div>
              ))
              }
            </div>
          }
          {NoProductStatus == true &&
            <div className=" d-flex justify-content-center align-content-center align-item-center align-self-center flex-column" style={{ height: '70vh' }} >
              <img className=' ' style={{ height: '200px', width: '200px' }} alt='img' src={girl} ></img>
              <label className="text-muted text-center" style={{ width: '30%' }} >No Item found</label>
            </div>
          }
          {loadingTrue == true ? (
            <div>
              <div className='cm-t-20' >

                <ShimmerC allproducts='yes' />
              </div>
              <div className='cm-t-20' >

                <ShimmerC allproducts='yes' />
              </div>
              <div className='cm-t-20' >

                <ShimmerC allproducts='yes' />
              </div>
            </div>
          ) : null}
          <div>
            {lastPageCondition == true ? (
              <div>
                <p className='d-flex justify-content-center f-500 f-20 cm-t-50' >Last page Reached</p>
              </div>
            ) : null}
          </div>
          {PopularProducts.length >= 1 ? (
            <div className=' d-flex justify-content-lg-end  cp-40'  >
              <Pagination >
                {Pagedata.current_page > '1' ? (<Pagination.Prev onClick={() => RiChecke('PreviousPage')} />) : null}
                <Pagination.Item onClick={() => RiChecke(1)} >{1}</Pagination.Item>
                {Pagedata.last_page > '1' ? (<Pagination.Item onClick={() => RiChecke(2)} >{2}</Pagination.Item>) : null}
                {Pagedata.last_page > '2' ? (<Pagination.Item onClick={() => RiChecke(3)} >{3}</Pagination.Item>) : null}
                {Pagedata.last_page > '3' ? (<Pagination.Item onClick={() => RiChecke(4)} >{4}</Pagination.Item>) : null}
                {Pagedata.last_page > '4' ? (<Pagination.Ellipsis />) : null}
                {Pagedata.last_page > '5' ? (<Pagination.Item onClick={() => RiChecke(Pagedata.last_page)} >{Pagedata.last_page}</Pagination.Item>) : null}
                {Pagedata.last_page > '5' ? (<Pagination.Next onClick={() => RiChecke('NextPage')} />) : null}
              </Pagination>
            </div>
          ) : null}
          <div>
          </div>
        </div>
      </div>
      <div style={{ marginTop: '10%' }} >
        <CFooter />
      </div>
    </div>
  )
}
export default AllProducts;








