import React, { useState, useRef } from 'react';
import './Storeitem.scss';
import Overlay from 'react-bootstrap/Overlay'
import Popover from 'react-bootstrap/Popover'
import { Link, useHistory } from 'react-router-dom'

function UserOptionsPopOver(props: any) {

  const ref = useRef(null);
  const [first_name] = useState(localStorage.getItem('first_name') || '')
  const [last_name] = useState(localStorage.getItem('last_name') || '')
  const history = useHistory();

  const logOut = () => {
    localStorage.removeItem('userid');
    localStorage.removeItem('token');
    history.push('/')
  };


  return (
    <div>
      <Overlay
        show={props.show}
        target={props.target}
        placement="bottom"
        container={ref.current}
        containerPadding={50}
      >
        <Popover style={{ width: '50%', marginTop: '1.5%' }} id="popover-contained">
          <Popover.Content >
            <div className='d-flex flex-row border-bottom cp-b-10 ' >
              <div className='cp-l-10 cp-t-10' >
                <label className=" secHeading label  main-font" >{first_name} {last_name}</label><br></br>
                <label className=" pText " >  <Link to="/MyAccount" className="link primary-color pText font-weight-bold  label main-font " style={{ color: 'rgb(27, 27, 27)', border: 0 }} >View Your Profile</Link> </label>
              </div>
            </div>
            <div className='border-bottom cp-b-10 d-flex flex-column cp-10' >
              <label className=" pText " >  <Link to="/MyAccount" className="link " style={{ color: 'rgb(27, 27, 27)', border: 0 }} >My Account</Link> </label>
              <label className=" pText " >  <Link to="/my-sales" className="link " style={{ color: 'rgb(27, 27, 27)', border: 0 }} >My Sales</Link> </label>
              <label className=" pText " >  <Link to="/purchases" className="link " style={{ color: 'rgb(27, 27, 27)', border: 0 }} >My Purchases</Link> </label>
            </div>
            <div className='cp-b-10 d-flex flex-column cp-10' >
              <label className=" pText " >  <Link to="/setting" className="link " style={{ color: 'rgb(27, 27, 27)', border: 0 }} >Settings</Link> </label>
              <label onClick={() => history.push('/faqs', ['customer'])} className=" pText hoverUnderLine touchAble " > Help Center </label>
              <label onClick={() => logOut()} className='pText label touchAble hoverUnderLine' >Log Out </label>
            </div>
          </Popover.Content>
        </Popover>
      </Overlay>
    </div>
  );
}

export default UserOptionsPopOver;
