import * as React from "react";
import { Children, cloneElement, isValidElement } from "react";

type Props = {
  children: any,
  color: string,
  stroke: number
}

export class TextStroke extends React.Component<Props> {
  createClones = (w: number, h: number, color?: string) => {
    const { children } = this.props;
    return Children.map(children, child => {
      if (isValidElement(child)) {
        const currentProps = child.props as any;
        const currentStyle = currentProps ? (currentProps.style || {}) : {};

        const newProps = {
          ...currentProps,
          style: {
            ...currentStyle,
            textShadowOffset: {
              width: w,
              height: h
            },
            textShadowColor: color,
            textShadowRadius: 1
          }
        }
        return cloneElement(child, newProps)
      }
      return child;
    });
  }

  render() {
    const {color, stroke, children} = this.props;
    const strokeW = stroke;
    const top = this.createClones(0, -strokeW * 1.2, color);
    const topLeft = this.createClones(-strokeW, -strokeW, color);
    const topRight = this.createClones(strokeW, -strokeW, color);
    const right = this.createClones(strokeW, 0, color);
    const bottom = this.createClones(0, strokeW, color);
    const bottomLeft = this.createClones(-strokeW, strokeW, color);
    const bottomRight = this.createClones(strokeW, strokeW, color);
    const left = this.createClones(-strokeW * 1.2, 0, color);

    return (
      <div>
        <div style={{position:'absolute'}}>{ left }</div>
        <div style={{position:'absolute'}}>{ right }</div>
        <div style={{position:'absolute'}}>{ bottom }</div>
        <div style={{position:'absolute'}}>{ top }</div>
        <div style={{position:'absolute'}}>{ topLeft }</div>
        <div style={{position:'absolute'}}>{ topRight }</div>
        <div style={{position:'absolute'}}>{ bottomLeft }</div>
        { bottomRight }
      </div>
    );
  }
}