<?php

namespace App\Http\Controllers;

use App\Models\Blog;
use App\Models\PageDetail;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use MicrosoftAzure\Storage\Blob\BlobRestProxy;

class AdminController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth',['except' => ['mainCategory','getAllBlogs','blogPageDetail','hospitalitySecurityPage',
        'securityGuardStaffingPage','eventSecurityPage','executiveProtectionPage','workPlageProtectionAndRifSecurityPage',
        'wareHouseProtectionPage','strikeSecurity']]);
    }

    //-----------------------------Services Pages------------------//
    public function hospitalitySecurityPage(){

        $page_detail = PageDetail::where('page_slug','services/hospitality-security')->first();
        return view('services_page/hospitality_security',compact('page_detail'));
    }

    public function securityGuardStaffingPage(){

        $page_detail = PageDetail::where('page_slug','services/security-guard-staffing')->first();
        return view('services_page/security_guard_staffing',compact('page_detail'));
    }

    public function eventSecurityPage(){

        $page_detail = PageDetail::where('page_slug','services/event-security')->first();
        return view('services_page/event_security',compact('page_detail'));
    }

    public function executiveProtectionPage(){

        $page_detail = PageDetail::where('page_slug','services/executive-protection')->first();
        return view('services_page/executive_protection',compact('page_detail'));
    }

    public function workPlageProtectionAndRifSecurityPage(){

        $page_detail = PageDetail::where('page_slug','services/workplace-protection-and-rif-security')->first();
        return view('services_page/workplace_protection_and_rif_security',compact('page_detail'));
    }

    public function wareHouseProtectionPage(){

        $page_detail = PageDetail::where('page_slug','services/warehouse-protection')->first();
        return view('services_page/warehouse_protection',compact('page_detail'));
    }

    public function strikeSecurity(){

        $page_detail = PageDetail::where('page_slug','services/strike-security')->first();
        return view('services_page/strike_security',compact('page_detail'));
    }
    //-----------------------------Services Pages End------------------//

    public function getAllBlogs(){
        $all_blogs = Blog::where('status','publish')->orderBy('updated_at','DESC')->get();
        $trending_blogs = Blog::where('status','publish')->orderBy('views','DESC')->get()->take(5);
        return view('blogpage',Compact('all_blogs','trending_blogs'));
    }

    public function blogPageDetail($id){

        $blog_page_detail = Blog::where('id',$id)->first();
        $trending_blogs = Blog::where('status','publish')->orderBy('views','DESC')->get()->take(5);
        if($blog_page_detail){
            $blog_page_detail->views = $blog_page_detail->views+1;
            $blog_page_detail->update();

            return view('blog_page_detail',Compact('blog_page_detail','trending_blogs'));
        }else{

            return response()->json(['status' => 404,'message'=> 'data not found']);
        }

    }

    public function DashBoard(){
        if(auth()->user()->user_type_id==1)
        {
          return redirect()->route('logout');
		}
        else
        {
        $totalblogs=Blog::all()->count();
        $totalpages=PageDetail::all()->count();
        // $totalEventPost=Posts::where('post_type_id','3')->count();
        // $totalBusinessPost=Posts::where('post_type_id','2')->count();
        // $totalReports = Report::all()->count();
        return view('admin.index',compact('totalblogs','totalpages'));
        }
    }

    public function blogs(){

        return view('admin.blogs');

    }

    public function blogIndex(){

        $blog_indexes = Blog::orderBy('id','DESC')->get();
        return view('admin.blogIndex',compact('blog_indexes'));
    }

    public function editBlogs($id){

        $edit_blog=Blog::where('id',$id)->first();
        return view('admin.editBlogs',compact('edit_blog'));
    }

    public function deleteBlog($id){

        $blog = Blog::where('id',$id)->first();
        Blog::where('id',$id)->delete();

        return redirect()->back()->with('message', 'Blog '.$blog->title.' Deleted Successfully');
    }

    public function blogDetail($id){

        $blog_details = Blog::where('id',$id)->first();
        return view ('admin.blogDetail',compact('blog_details'));
    }

    public function blogStore(Request $request){

        try{
            $request->validate([
                'image' => 'nullable|image|mimes:png,jpg,jpeg,webp|max:2048'
            ]);

            if(($request->hasFile('image')) == NULL || ($request->input('title')) == NULL) {

                $msg = 'Please Fill All Fields.';
                $arr = array("status" => 200, "msg" => $msg);
                return \Response::json($arr);
            }

            $blog = new Blog;
            $blog->title = $request->input('title');
            if($request->input('slug') == NULL){
                $slug = Str::slug($request->input('title'));
            }else{
                $slug = $request->input('slug');
            }

            $blog->slug = $slug;
            $blog->description = $request->input('wysiwyg-editor');
            $blog->meta_title = $request->input('Meta-Title');

            if(($request->hasFile('image'))) {
                $fileName = time().'.'.$request->image->extension();
                $request->image->move(public_path('images/blogs'), $fileName);
                $filePath = public_path('images/blogs/' . $fileName);
                $ContentFile = fopen($filePath, 'r');
                $Account = BlobRestProxy::createBlobService(env('AZURE_LARAVELES'));
                $success = $Account->createBlockBlob("lesfemmes/adminpictures", $fileName, $ContentFile);
                $blog->thumbnail_blog = 'https://dominioninc.blob.core.windows.net/lesfemmes/adminpictures/'.$fileName;
            }

            $blog->meta_description = $request->input('Meta-Description');
            $blog->meta_keywords = $request->input('Meta-Keyworks');
            $blog->status = $request->input('status');
            $blog->save();

            $msg = 'added seccessfully.';

            $arr = array("status" => 200, "msg" => $msg);
        }catch (\Illumicate\Database\QueryExecption $ex){
            $msg = $ex->getMessage();
            if(issset($ex->errorInfo[2])) :
                $msg = $ex->errorInfo[2];
            endif;

            $arr = array("status" => 400, "msg" => $msg, "result" => array());
        }
        return \Response::json($arr);
    }

    public function blogUpdate(Request $request){

        try{
            $blog = Blog::where('id',$request->input('id'))->first();
            $request->validate([
                'image' => 'nullable|image|mimes:png,jpg,jpeg|max:2048'
            ]);
            $blog->title = $request->input('title');

            if($request->input('slug') == NULL){
                $slug = Str::slug($request->input('title'));
            }else{
                $slug = $request->input('slug');
            }

            $blog->slug = $slug;
            $blog->description = $request->input('wysiwyg-editor');
            $blog->meta_title = $request->input('Meta-Title');
            if($request->hasFile('image')) {

                $fileName = time().'.'.$request->image->extension();
                $request->image->move(public_path('images/blogs'), $fileName);
                $filePath = public_path('images/blogs/' . $fileName);
                $ContentFile = fopen($filePath, 'r');
                $Account = BlobRestProxy::createBlobService(env('AZURE_LARAVELES'));
                $success = $Account->createBlockBlob("lesfemmes/adminpictures", $fileName, $ContentFile);
                $blog->thumbnail_blog = 'https://dominioninc.blob.core.windows.net/lesfemmes/adminpictures/'.$fileName;
            }

            $blog->meta_description = $request->input('Meta-Description');
            $blog->meta_keywords = $request->input('Meta-Keyworks');
            $blog->status = $request->input('status');
            $blog->update();

            $msg = 'update successfully.';

            $arr = array("status" => 200, "msg" => $msg);
        }catch (\Illumicate\Database\QueryExecption $ex){
            $msg = $ex->getMessage();
            if(issset($ex->errorInfo[2])) :
                $msg = $ex->errorInfo[2];
            endif;

            $arr = array("status" => 400, "msg" => $msg, "result" => array());
        }
        return \Response::json($arr);
    }

    public function upload(Request $request)
    {
        if($request->hasFile('upload')) {
            $originName = $request->file('upload')->getClientOriginalName();
            $fileName = pathinfo($originName, PATHINFO_FILENAME);
            $extension = $request->file('upload')->getClientOriginalExtension();
            $fileName = $fileName.'_'.time().'.'.$extension;

            $request->file('upload')->move(public_path('images/blogs'), $fileName);

            $CKEditorFuncNum = $request->input('CKEditorFuncNum');
            $url = asset('https://dominioninc.blob.core.windows.net/lesfemmes/adminpictures/'.$fileName);
            $msg = 'Image successfully uploaded';

            $filePath = public_path('images/blogs/' . $fileName);
            $ContentFile = fopen($filePath, 'r');
            $Account = BlobRestProxy::createBlobService(env('AZURE_LARAVELES'));
            $success = $Account->createBlockBlob("lesfemmes/adminpictures", $fileName, $ContentFile);

            $response = "<script>window.parent.CKEDITOR.tools.callFunction($CKEditorFuncNum, '$url', '$msg')</script>";

            @header('Content-type: text/html; charset=utf-8');
            echo $response;
        }
    }

    public function categoryPageDetail($id){

        $category_page_details = PageDetail::where('id',$id)->first();
        return view ('admin.categoryPageDetail',compact('category_page_details'));
    }

    public function deleteCategoryPage($id){

        $category_page = PageDetail::where('id',$id)->first();
        PageDetail::where('id',$id)->delete();

        return redirect()->back()->with('message', 'Category Page '.$category_page->page_title.' Deleted Successfully');
    }

    public function pageIndex(){

        $page_index = PageDetail::orderBy('id','DESC')->get();
        return view('admin.pageIndex',compact('page_index'));
    }

    public function allPages(){

        return view('admin.pages');
    }

    public function editCategoryPageDetail($id){

        $edit_category_page_detail=PageDetail::where('id',$id)->first();

        return view('admin.editCategoryPageDetail',compact('edit_category_page_detail'));
    }


    public function pageStore(Request $request){

        try{
            $slug  = NULL;
            $type = NULL;
            $category = null;
            if($request->input('type') != NULL){
                if($request->input('type') == 'Services'){
                    $type = $request->input('type');
                    if($request->input('category') == null){
                        $slug = $type;
                    }
                    elseif($request->input('category') != null){
                        $category = $request->input('category');
                        $slug = $category;
                    }
                }else {
                    $type = $request->input('type');
                    $slug = $type;
                }
            }
            $page_detail = new PageDetail;
            $page_detail->type = $type;
            $page_detail->page_title = $request->input('page-title');

            if($slug == NULL){
                $page_detail->page_slug = $request->input('slug');
            }else{
                $page_detail->page_slug = $slug;
            }
            $page_detail->page_detail = $request->input('wysiwyg-editor');
            $page_detail->category = $category;
            $page_detail->meta_title = $request->input('meta-title');
            $page_detail->meta_description = $request->input('meta-description');
            $page_detail->meta_keyword = $request->input('meta-keyworks');
            $page_detail->save();

            $msg = 'added seccessfully.';

            $arr = array("status" => 200, "msg" => $msg);
        }catch (\Illumicate\Database\QueryExecption $ex){
            $msg = $ex->getMessage();
            if(issset($ex->errorInfo[2])) :
                $msg = $ex->errorInfo[2];
            endif;

            $arr = array("status" => 400, "msg" => $msg, "result" => array());
        }
        return \Response::json($arr);
    }

    public function updateCategoryPageDetail(Request $request){

        try{
            $blog = PageDetail::where('id',$request->input('id'))->first();

            $type = $request->input('type');
            $blog->type = $type;
            $blog->category = $request->input('category');
            $blog->page_title = $request->input('page-title');
            $blog->page_slug = $request->input('slug');
            $blog->page_detail = $request->input('wysiwyg-editor');
            $blog->meta_title = $request->input('meta-title');
            $blog->meta_description = $request->input('meta-description');
            $blog->meta_keyword = $request->input('meta-keyworks');
            $blog->update();

            $msg = 'updated seccessfully.';

            $arr = array("status" => 200, "msg" => $msg);
        }catch (\Illumicate\Database\QueryExecption $ex){
            $msg = $ex->getMessage();
            if(issset($ex->errorInfo[2])) :
                $msg = $ex->errorInfo[2];
            endif;

            $arr = array("status" => 400, "msg" => $msg, "result" => array());
        }
        return \Response::json($arr);
    }

    public function getpageDetail(Request $request){

        $page_detail = PageDetail::where('page_slug',$request->page_slug)->first();

        return response()->json(['status' => 200,'page_detail'=>$page_detail]);
    }

    public function getAllPages(){

        $all_pages = PageDetail::orderBy('id','DESC')->get();

        return response()->json(['status' => 200,'all_pages'=>$all_pages]);
    }

    public function mainCategory(Request $request)
    {
        if($request->luxury == "Services"){

            return response()->json(['data'=>'Services']);
        }
    }

}
